/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.actprof;

import com.ibm.hwmca.base.actprof.ActivationProfile;
import com.ibm.hwmca.base.actprof.ActivationProfileListConstants;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.ColumnDescriptor;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

public class ActivationProfileListBean
extends PanelBean
implements ActivationProfileListConstants {
    protected List profileList;
    int numColumns = 3;
    private static final String TRACE_MASKT = "XPROBEAT";
    private static final String TRACE_MASKF = "XPROBEAF";
    private static final String TRACE_MASKD = "XPROBEAD";
    ItemDescriptor[] m_idProfileListTable;
    ColumnDescriptor[] m_cdProfileListTableStructure;
    protected int[] m_iProfileListTableSelection;
    private boolean viewOnly;
    ActivationProfile lastEdited;

    public void setViewOnly(boolean viewOnly) {
        this.viewOnly = viewOnly;
    }

    public ColumnDescriptor[] getProfileListTableRowStructure() {
        return this.m_cdProfileListTableStructure;
    }

    public int getProfileListTableRowStatus() {
        return 3;
    }

    public int getProfileListTableRowCount() {
        return this.profileList.size();
    }

    public ItemDescriptor[] getProfileListTableRowAt(int index) {
        ActivationProfile p = (ActivationProfile)this.profileList.get(index);
        ItemDescriptor[] id = new ItemDescriptor[]{new ItemDescriptor("Name" + index + this.getMountPrefix(), p.getProfileName().toString()), new ItemDescriptor("Type" + index + this.getMountPrefix(), p.getProfileType().toString()), new ItemDescriptor("Desc" + index + this.getMountPrefix(), p.getProfileDescription().toString())};
        return id;
    }

    public void setProfileListTableRowAt(int index, ItemDescriptor[] items) {
    }

    public int[] getProfileListTableSelection() {
        return this.m_iProfileListTableSelection;
    }

    public void setProfileListTableSelection(int[] selected) throws IllegalUserDataException {
        this.m_iProfileListTableSelection = selected;
        if (selected.length > 0) {
            int rowNum = selected[0];
            ActivationProfile p = (ActivationProfile)this.profileList.get(rowNum);
            if (!this.viewOnly) {
                this.userTaskManager.setEnabled(this.getMountPrefix() + "DeleteButton", p.isDeletable());
            }
        }
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() {
    }

    public void save() {
    }

    public void prepare() {
        Trace.trace(TRACE_MASKF, "-> ActivationProfileListBean.prepare()");
        if (this.viewOnly) {
            ResourceBundle properties = ResourceBundle.getBundle("com.ibm.hwmca.base.actprof.res.ActivationProfileListRes");
            this.userTaskManager.setCaptionText(this.getMountPrefix() + "CustomizeButton", properties.getString("CustomizeButton.View"));
            this.userTaskManager.setEnabled(this.getMountPrefix() + "DeleteButton", false);
            this.userTaskManager.setShown(this.getMountPrefix() + "DeleteButton", false);
        } else {
            Trace.trace(TRACE_MASKF, "not view only");
        }
        Trace.trace(TRACE_MASKF, "<- ActivationProfileListBean.prepare()");
    }

    public void update(Object newData) {
        Map map;
        String command;
        Trace.trace(TRACE_MASKF, "-> ActivationProfileListBean.update()");
        if (newData instanceof Map && (command = (String)(map = (Map)newData).get("command")).equals("DeleteButton") && Boolean.TRUE.equals((Boolean)map.get("DeleteButton"))) {
            int rowNum = this.m_iProfileListTableSelection[0];
            ActivationProfile p = (ActivationProfile)this.profileList.get(rowNum);
            this.userTaskManager.removeRow(this.getMountPrefix() + "ProfileListTable", rowNum);
            this.profileList.remove(p);
            this.userTaskManager.refreshElement(this.getMountPrefix() + "ProfileListTable");
            Trace.trace(TRACE_MASKT, "done with delete");
        }
        Trace.trace(TRACE_MASKF, "<- ActivationProfileListBean.update()");
    }

    public void load() {
        ActivationProfile p;
        Iterator it;
        Trace.trace(TRACE_MASKF, "-> ActivationProfileListBean.load()");
        int[] selectedRows = new int[]{};
        int i = 0;
        if (this.lastEdited != null) {
            it = this.profileList.iterator();
            while (it.hasNext()) {
                p = (ActivationProfile)it.next();
                if (p.equals(this.lastEdited)) {
                    selectedRows = new int[]{i};
                }
                ++i;
            }
        }
        i = 0;
        if (selectedRows.length == 0) {
            it = this.profileList.iterator();
            while (it.hasNext()) {
                p = (ActivationProfile)it.next();
                if (p.isSelected()) {
                    int[] tempSelection = new int[selectedRows.length + 1];
                    System.arraycopy(selectedRows, 0, tempSelection, 0, selectedRows.length);
                    tempSelection[selectedRows.length] = i;
                    selectedRows = tempSelection;
                }
                ++i;
            }
        }
        this.m_iProfileListTableSelection = selectedRows;
        Trace.trace(TRACE_MASKF, "<- ActivationProfileListBean.load()");
    }

    public void setData(List profileList) {
        this.profileList = profileList;
    }

    public List getData() {
        return this.profileList;
    }

    public void setLastEditedProfile(ActivationProfile lastEdited) {
        this.lastEdited = lastEdited;
    }

    public void panelAction(TaskActionEvent e) {
        Trace.trace(TRACE_MASKF, "-> ActivationProfileListBean.panelAction()");
        String command = e.getActionCommand();
        PanelTaskletRequest request = new PanelTaskletRequest(this.getClass().getName() + this.getMountPrefix());
        Trace.trace(TRACE_MASKF, "  Received '" + command + "' from item '" + e.getElementName() + "'");
        if (command.endsWith("CANCEL")) {
            this.dispose();
        } else {
            int[] z = this.getProfileListTableSelection();
            if (z != null && z.length > 0) {
                Trace.trace(TRACE_MASKF, "   Valid table selection, posting request to tasklet");
                if (command.endsWith("CustomizeButton")) {
                    request.setData("command", "CustomizeButton");
                } else if (command.endsWith("DeleteButton")) {
                    request.setData("command", "DeleteButton");
                }
                request.setData("profile", this.profileList.get(z[0]));
                this.postTaskletRequest(request);
            }
        }
        Trace.trace(TRACE_MASKF, "<- ActivationProfileListBean.panelAction()");
    }
}

